define(['angular', 'app'], function (angular, app) {
	"use strict";
	app.service('resourceDirectory', function ($http, $q, $filter) {
		var resourceDirectory = {},
			helper = {},
			isReady;

		helper.getDirectoryPath = function () {
			var deferred = $q.defer();
			var servicesPath = $http({
				url: 'resources.json',
				method: "GET"
			}).success(function(data) {
				var path = $filter('filter')(data.link, {title: "health-adapter"})[0].href;
				deferred.resolve(path);
			});
			return deferred.promise;
		};

		resourceDirectory.fetch = function () {

			if (isReady) {
				return isReady.promise;
			}

			isReady = $q.defer();

			helper.getDirectoryPath().then(function (path) {
				$http.get(path).success(function (response) {
					var directory = {};
					response['link'].forEach(function (link) {
						directory[link['title']] = link['href'];
					});
					isReady.resolve(directory);
				}).error(function (error) {
					isReady.reject(error);
					isReady = null;
				});
			}, function (error) {
				isReady.reject(error);
			});

			return isReady.promise;

		};

		return resourceDirectory;
	});
});
